<?php
/**
 * Register Blocks 
 * @package GutSliderBlocks
 */

 if( ! defined( 'ABSPATH' ) ) {
 	exit;
 } 

 if( ! class_exists( 'GutSliderBlocks_Registration' ) ) {

    /**
     * @since 1.0.0
     * @package GutSlider Blocks
     */
    class GutSliderBlocks_Registration {

        /**
         * Constructor
         * 
         * @since 1.0.0
         * @return void
         */
        public function __construct() {
            add_action( 'init', array ( $this, 'register_blocks'  ) );
			// check block theme 
			if( ! wp_is_block_theme() ) {
				add_filter( 'should_load_separate_core_block_assets', '__return_true' );
			}
        }

        /**
         * Register Blocks
         * 
         * @since 1.0.0
         * @return void
         */
        public function register_blocks() {

            $blocks = get_option( 'gutslider_blocks', $this->get_gutslider_blocks() );
        
            if ( ! empty( $blocks ) && is_array( $blocks ) ) {
                foreach ( $blocks as $block ) {
                    $path = GUTSLIDER_DIR_PATH;
        
                    if( isset( $block['is_pro'] ) && $block['is_pro'] === true && defined( 'GUTSLIDER_PRO_PATH' ) ) {
                        $path = GUTSLIDER_PRO_PATH;
                    }
        
                    $block_name = trailingslashit( $path ) . 'build/blocks/' . $block['name'];
                    $block_key = $block['name'];

                    if($this->gutslider_is_block_enabled($block_key)) {
                        if( file_exists( $block_name ) ) {
                            // Check if the block is not already registered
                            if ( ! WP_Block_Type_Registry::get_instance()->is_registered( 'gutsliders/' . $block['name'] ) ) {
                                register_block_type( $block_name );
                            }
                        }
                    } else {
                        // Unregister the block if it is disabled
                        if( WP_Block_Type_Registry::get_instance()->is_registered( 'gutsliders/' . $block['name'] ) ) {
                            unregister_block_type( 'gutsliders/' . $block['name'] );
                        }
                    }
                }
            }
        }

         /**
         * Get GutSlider Blocks
         */
        public function get_gutslider_blocks() {
            return require GUTSLIDER_DIR_PATH . 'includes/api/blocks.php';
        }

        /**
         * Check if a block is enabled
         */
        public function gutslider_is_block_enabled($block_name) {
            $option_key = 'gut_' . str_replace('-', '_', $block_name);
            return (bool) get_option($option_key, true);
        }


    }

 }

    new GutSliderBlocks_Registration(); // Initialize the class.